//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Text.RegularExpressions;

namespace Samples {
    public class RegExMatcherMulti {
        public static void Main(String[] args){
            Regex digitregex = new Regex("(?<number>\\d+)");
            String s = "abc 123 def 456 ghi 789";

            if ( args.Length > 0 ) {
                s = String.Join(" ", args);
            }

            MatchCollection mc = digitregex.Matches(s);

            if ( mc.Count > 0 ) {
                System.Console.WriteLine("Cyfry:");
                foreach (Match m in mc) {
                    System.Console.WriteLine("  " + m.Value);
                }
            } else {
                System.Console.WriteLine("[" + s + "] nie zawiera liczb.");
            }

            System.Console.WriteLine();
            System.Console.WriteLine("Wcinij Enter, aby kontynuowa...");
            System.Console.ReadLine();
        }
    }
}